﻿// create compact data
var saveData = {};
saveData.format = 2;		// specify "compact" file format
saveData.width = DATA.map.width;
saveData.height = DATA.map.height;
saveData.chipset = DATA.map.chipset;
// layers
saveData.layers = [];
for(var L=0; L<DATA.map.layers.length; L++)
{
	var layerString = "_";		// prevents XML reader from seeing this as a HUGE number
	for(var xx=0; xx<DATA.map.width; xx++)
	{
		for(var yy=0; yy<DATA.map.height; yy++)
		{
			var thisData = DATA.map.layers[L][xx][yy];
			var thisString = thisData.toString( 36 );
			// add padding if neccessary
			if(thisString.length==1){
				thisString = "0"+thisString;
			}// if:  string is too short
			layerString += thisString;		// append the data
		}// for:  height
	}// for:  width
	saveData.layers.push( layerString );
}// for:  layers
// collision
var collisionString = "_";		// prevents XML reader from seeing this as a HUGE number
for(var xx=0; xx<DATA.map.width; xx++)
{
	for(var yy=0; yy<DATA.map.height; yy++)
	{
		var thisData = DATA.map.collision[xx][yy];
		var thisString = thisData.toString( 36 );
		collisionString += thisString;		// append the data
	}// for:  height
}// for:  width
saveData.collision = collisionString;





// convert data to XML
XML.prototype.ignoreWhite = true;
var saveXml = new XML();
writeXml( saveData, saveXml, "map" );
var saveData = String(saveXml);

mdm.FileSystem.saveFile( fileName, saveXml );		// create empty XML file



// Display map name
var startAt = fileName.lastIndexOf("\\") + 1;
var file = fileName.substr(startAt);
mdm.Forms.MainForm.title = "Map Editor:  "+file;

// remember last folder used
var endAt = fileName.lastIndexOf("\\") + 1;
var path = fileName.substr(0, endAt);
Dialogs.BrowseFile.defaultDirectory = path;



// confirm save
XML.prototype.ignoreWhite = true;
var newXml = new XML();
// // load the saved file
newXml.load( fileName );
newXml.onData = function( loadData )
{
	if( loadData.length != saveData.length )
	{
		mdm.Dialogs.prompt('Save FAILED!\nUsing "Save To Clipboard" instead.');
		#include "program/menu_saveToClipboard.as"
	}else{
		// do nothing
	}
}// onData()
